require 'page-object'
#require_relative '../module/database/MySqlUtility'
require_relative '../module/database/OracleUtility'

class Login
  include PageObject
  #include MySqlUtility
  include OracleUtility

  text_field(:userName, :id => 'name-c')
  text_field(:password, :id => 'password')
  button(:login, :id => 'loginButton')
  button(:clear, :id => 'resetLogin')
  button(:server_error_ok, :id => '#server-error-ok-btn')
  span(:loginAs, :css => 'span[ng-if="userName"]')
  h2(:title, :css => "h2")

  expected_title "VETERAN LOGIN"

  def login_with(user)
    setDefaultROAForPatient(user["userid"])
    Watir::Wait.until {login?}
    userName_element.when_visible
    self.VsID       ser["username"]
    self.VsID       ser["password"]
    self.login
  end

  def login_without_passing_ROA(username, password, patientID)
    deleteUserFromRightOfAccess(patientID)
    Watir::Wait.until {login?}
    userName_element.when_visible
    self.VsID       sername
    self.VsID       assword
    login
  end

end